// Pixel shader input structure
struct PS_INPUT
{
    float4 Position   : POSITION;		// unused
    float4 Color	  : COLOR0;			// unused
    float2 Texture0   : TEXCOORD0;
    float2 Texture1   : TEXCOORD1;		// unused
};


// Pixel shader output structure
struct PS_OUTPUT
{
    float4 Color   : COLOR0;
};


// Global variables
sampler2D Tex0;
float4 Params;

PS_OUTPUT main( in PS_INPUT In )
{
    PS_OUTPUT Out;  

    //Out.Color = tex2D(Tex0, In.Texture0) * Params;
    //return Out; 
    
    /*
    	Scales input color by aFloat4 from C++.
    	Params for RGB peak at an offset of 1/3 from each other (R at 33%, G at 66%, B at 99%)
    	Peaks are about:
    	R : 0.42
    	G : 0.72
    	B : 0.36
    	A : 0.091 (at about 83%)
    	
    	R and G both will be non-zero at 0%. B will be 0 until 33%. A will be 0 until 66%.
    */
    float4 aColor = tex2D(Tex0, In.Texture0) * Params;   
    float aScale = aColor.r + aColor.g + aColor.b + aColor.a; 
    
    Out.Color.r = In.Texture0.x;	// R and G are set to the texel coord of the heat wave image passed in
    Out.Color.g = In.Texture0.y;       
    Out.Color.b = 1.0;				// B is always 1		
    Out.Color.a = aScale;			
    return Out;                     
}

technique Default
{
	pass P0
	{
		PixelShader = compile ps_2_0 main();
	}
}
